# coding: iso-8859-1



# Ecrit les fichiers et dossiers ncessaires au fonctionnement de
# l'application, notamment le dossier DMK et les fichiers de langue et de
# configuration
#
def preparer_terrain


  # Charge le fichier de langue
  Traduire.charger_language

  # Slectionne la langue par dfaut
  Traduire.set_language(:english)
  #puts Traduire.get_language

  verif = verifier_dossier_dmk
  if verif != 0

    #puts "---------- DreaMaker v#{$dmk_version} ----------"
    #puts ""
    
    case verif
      when 1
        creer_dossier_dmk
      when 2
        effacer_fichier_dmk
        creer_dossier_dmk
    end
    #pause if exe?
  end



  if $options["language"] != Traduire.get_language
    Traduire.set_language($options["language"].downcase.intern)
  end


end



def is_folder_rmxp?(path)
  if File.exists?(path.join("Scripts.rxdata"))
    return true
  end
  return false
end

def is_folder_rm03?(path)
  if File.exists?(path.join("RPG_RT.ldb"))
    return true
  end
  return false
end


def effacer_fichier_dmk
  begin
    File.delete($e.dossier_dmk)
  rescue
    raise(DMKE_Action.new("delete #{$e.dossier_dmk}"))
  end
end


def creer_dossier_dmk
  begin
    FileUtils.mkdir($e.dossier_dmk)
  rescue
    raise(DMKE_Action.new("write #{$e.dossier_dmk}"))
  end
end


def verifier_dossier_dmk

  # On regarde s'il y a un dossier DMK
  if File.exists?($e.dossier_dmk) == false
    return 1
  end

  if File.directory?($e.dossier_dmk) == false
    return 2
  end

  return 0

end






def charger_police

  verifier_police(true)

  file_police = $e.dossier_local(F_POLICE)

  begin
    police = DA::marshal_read(file_police)
  rescue
    raise(DMKE_Action.new("read #{file_police}"))
  end

  return police

end


